// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// Copyright the Browserify authors. MIT License.
import { fromFileUrl } from "../path/from_file_url.ts";
/**
 * Convert a URL or string to a path
 * @param pathUrl A URL or string to be converted
 */ export function toPathString(pathUrl) {
  return pathUrl instanceof URL ? fromFileUrl(pathUrl) : pathUrl;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAwLjIxNy4wL2ZzL190b19wYXRoX3N0cmluZy50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgMjAxOC0yMDI0IHRoZSBEZW5vIGF1dGhvcnMuIEFsbCByaWdodHMgcmVzZXJ2ZWQuIE1JVCBsaWNlbnNlLlxuLy8gQ29weXJpZ2h0IHRoZSBCcm93c2VyaWZ5IGF1dGhvcnMuIE1JVCBMaWNlbnNlLlxuXG5pbXBvcnQgeyBmcm9tRmlsZVVybCB9IGZyb20gXCIuLi9wYXRoL2Zyb21fZmlsZV91cmwudHNcIjtcblxuLyoqXG4gKiBDb252ZXJ0IGEgVVJMIG9yIHN0cmluZyB0byBhIHBhdGhcbiAqIEBwYXJhbSBwYXRoVXJsIEEgVVJMIG9yIHN0cmluZyB0byBiZSBjb252ZXJ0ZWRcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIHRvUGF0aFN0cmluZyhcbiAgcGF0aFVybDogc3RyaW5nIHwgVVJMLFxuKTogc3RyaW5nIHtcbiAgcmV0dXJuIHBhdGhVcmwgaW5zdGFuY2VvZiBVUkwgPyBmcm9tRmlsZVVybChwYXRoVXJsKSA6IHBhdGhVcmw7XG59XG4iXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsMEVBQTBFO0FBQzFFLGlEQUFpRDtBQUVqRCxTQUFTLFdBQVcsUUFBUSwyQkFBMkI7QUFFdkQ7OztDQUdDLEdBQ0QsT0FBTyxTQUFTLGFBQ2QsT0FBcUI7RUFFckIsT0FBTyxtQkFBbUIsTUFBTSxZQUFZLFdBQVc7QUFDekQifQ==