// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
/**
 * Utilities for working with the
 * {@link https://developer.mozilla.org/en-US/docs/Web/API/Streams_API | Streams API}.
 *
 * Includes buffering and conversion.
 *
 * @module
 */ export * from "./buffer.ts";
export * from "./byte_slice_stream.ts";
export * from "./delimiter_stream.ts";
export * from "./early_zip_readable_streams.ts";
export * from "./iterate_reader.ts";
export * from "./limited_bytes_transform_stream.ts";
export * from "./limited_transform_stream.ts";
export * from "./merge_readable_streams.ts";
export * from "./readable_stream_from_reader.ts";
export * from "./reader_from_iterable.ts";
export * from "./reader_from_stream_reader.ts";
export * from "./text_delimiter_stream.ts";
export * from "./text_line_stream.ts";
export * from "./to_array_buffer.ts";
export * from "./to_blob.ts";
export * from "./to_json.ts";
export * from "./to_text.ts";
export * from "./to_transform_stream.ts";
export * from "./writable_stream_from_writer.ts";
export * from "./writer_from_stream_writer.ts";
export * from "./zip_readable_streams.ts";
//# sourceMappingURL=data:application/json;base64,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