// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
/**
 * Returns all distinct elements that appear in any of the given arrays.
 *
 * @example
 * ```ts
 * import { union } from "https://deno.land/std@$STD_VERSION/collections/union.ts";
 * import { assertEquals } from "https://deno.land/std@$STD_VERSION/assert/assert_equals.ts";
 *
 * const soupIngredients = ["Pepper", "Carrots", "Leek"];
 * const saladIngredients = ["Carrots", "Radicchio", "Pepper"];
 * const shoppingList = union(soupIngredients, saladIngredients);
 *
 * assertEquals(shoppingList, ["Pepper", "Carrots", "Leek", "Radicchio"]);
 * ```
 */ export function union(...arrays) {
  const set = new Set();
  for (const array of arrays){
    for (const element of array){
      set.add(element);
    }
  }
  return Array.from(set);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAwLjIxNy4wL2NvbGxlY3Rpb25zL3VuaW9uLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAyMDE4LTIwMjQgdGhlIERlbm8gYXV0aG9ycy4gQWxsIHJpZ2h0cyByZXNlcnZlZC4gTUlUIGxpY2Vuc2UuXG4vLyBUaGlzIG1vZHVsZSBpcyBicm93c2VyIGNvbXBhdGlibGUuXG5cbi8qKlxuICogUmV0dXJucyBhbGwgZGlzdGluY3QgZWxlbWVudHMgdGhhdCBhcHBlYXIgaW4gYW55IG9mIHRoZSBnaXZlbiBhcnJheXMuXG4gKlxuICogQGV4YW1wbGVcbiAqIGBgYHRzXG4gKiBpbXBvcnQgeyB1bmlvbiB9IGZyb20gXCJodHRwczovL2Rlbm8ubGFuZC9zdGRAJFNURF9WRVJTSU9OL2NvbGxlY3Rpb25zL3VuaW9uLnRzXCI7XG4gKiBpbXBvcnQgeyBhc3NlcnRFcXVhbHMgfSBmcm9tIFwiaHR0cHM6Ly9kZW5vLmxhbmQvc3RkQCRTVERfVkVSU0lPTi9hc3NlcnQvYXNzZXJ0X2VxdWFscy50c1wiO1xuICpcbiAqIGNvbnN0IHNvdXBJbmdyZWRpZW50cyA9IFtcIlBlcHBlclwiLCBcIkNhcnJvdHNcIiwgXCJMZWVrXCJdO1xuICogY29uc3Qgc2FsYWRJbmdyZWRpZW50cyA9IFtcIkNhcnJvdHNcIiwgXCJSYWRpY2NoaW9cIiwgXCJQZXBwZXJcIl07XG4gKiBjb25zdCBzaG9wcGluZ0xpc3QgPSB1bmlvbihzb3VwSW5ncmVkaWVudHMsIHNhbGFkSW5ncmVkaWVudHMpO1xuICpcbiAqIGFzc2VydEVxdWFscyhzaG9wcGluZ0xpc3QsIFtcIlBlcHBlclwiLCBcIkNhcnJvdHNcIiwgXCJMZWVrXCIsIFwiUmFkaWNjaGlvXCJdKTtcbiAqIGBgYFxuICovXG5leHBvcnQgZnVuY3Rpb24gdW5pb248VD4oLi4uYXJyYXlzOiBJdGVyYWJsZTxUPltdKTogVFtdIHtcbiAgY29uc3Qgc2V0ID0gbmV3IFNldDxUPigpO1xuXG4gIGZvciAoY29uc3QgYXJyYXkgb2YgYXJyYXlzKSB7XG4gICAgZm9yIChjb25zdCBlbGVtZW50IG9mIGFycmF5KSB7XG4gICAgICBzZXQuYWRkKGVsZW1lbnQpO1xuICAgIH1cbiAgfVxuXG4gIHJldHVybiBBcnJheS5mcm9tKHNldCk7XG59XG4iXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsMEVBQTBFO0FBQzFFLHFDQUFxQztBQUVyQzs7Ozs7Ozs7Ozs7Ozs7Q0FjQyxHQUNELE9BQU8sU0FBUyxNQUFTLEdBQUcsTUFBcUI7RUFDL0MsTUFBTSxNQUFNLElBQUk7RUFFaEIsS0FBSyxNQUFNLFNBQVMsT0FBUTtJQUMxQixLQUFLLE1BQU0sV0FBVyxNQUFPO01BQzNCLElBQUksR0FBRyxDQUFDO0lBQ1Y7RUFDRjtFQUVBLE9BQU8sTUFBTSxJQUFJLENBQUM7QUFDcEIifQ==