// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
/** Utility functions for media types (MIME types).
 *
 * This API is inspired by the GoLang {@linkcode https://pkg.go.dev/mime | mime} package
 * and {@link https://github.com/jshttp/mime-types | jshttp/mime-types}, and is
 * designed to integrate and improve the APIs from
 * {@link https://deno.land/x/media_types | x/media_types}.
 *
 * The `vendor` folder contains copy of the
 * {@link https://github.com/jshttp/mime-types | jshttp/mime-db} `db.json` file along
 * with its license.
 *
 * @module
 */ export * from "./content_type.ts";
export * from "./extension.ts";
export * from "./extensions_by_type.ts";
export * from "./format_media_type.ts";
export * from "./get_charset.ts";
export * from "./parse_media_type.ts";
export * from "./type_by_extension.ts";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAwLjIxNy4wL21lZGlhX3R5cGVzL21vZC50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgMjAxOC0yMDI0IHRoZSBEZW5vIGF1dGhvcnMuIEFsbCByaWdodHMgcmVzZXJ2ZWQuIE1JVCBsaWNlbnNlLlxuLy8gVGhpcyBtb2R1bGUgaXMgYnJvd3NlciBjb21wYXRpYmxlLlxuXG4vKiogVXRpbGl0eSBmdW5jdGlvbnMgZm9yIG1lZGlhIHR5cGVzIChNSU1FIHR5cGVzKS5cbiAqXG4gKiBUaGlzIEFQSSBpcyBpbnNwaXJlZCBieSB0aGUgR29MYW5nIHtAbGlua2NvZGUgaHR0cHM6Ly9wa2cuZ28uZGV2L21pbWUgfCBtaW1lfSBwYWNrYWdlXG4gKiBhbmQge0BsaW5rIGh0dHBzOi8vZ2l0aHViLmNvbS9qc2h0dHAvbWltZS10eXBlcyB8IGpzaHR0cC9taW1lLXR5cGVzfSwgYW5kIGlzXG4gKiBkZXNpZ25lZCB0byBpbnRlZ3JhdGUgYW5kIGltcHJvdmUgdGhlIEFQSXMgZnJvbVxuICoge0BsaW5rIGh0dHBzOi8vZGVuby5sYW5kL3gvbWVkaWFfdHlwZXMgfCB4L21lZGlhX3R5cGVzfS5cbiAqXG4gKiBUaGUgYHZlbmRvcmAgZm9sZGVyIGNvbnRhaW5zIGNvcHkgb2YgdGhlXG4gKiB7QGxpbmsgaHR0cHM6Ly9naXRodWIuY29tL2pzaHR0cC9taW1lLXR5cGVzIHwganNodHRwL21pbWUtZGJ9IGBkYi5qc29uYCBmaWxlIGFsb25nXG4gKiB3aXRoIGl0cyBsaWNlbnNlLlxuICpcbiAqIEBtb2R1bGVcbiAqL1xuXG5leHBvcnQgKiBmcm9tIFwiLi9jb250ZW50X3R5cGUudHNcIjtcbmV4cG9ydCAqIGZyb20gXCIuL2V4dGVuc2lvbi50c1wiO1xuZXhwb3J0ICogZnJvbSBcIi4vZXh0ZW5zaW9uc19ieV90eXBlLnRzXCI7XG5leHBvcnQgKiBmcm9tIFwiLi9mb3JtYXRfbWVkaWFfdHlwZS50c1wiO1xuZXhwb3J0ICogZnJvbSBcIi4vZ2V0X2NoYXJzZXQudHNcIjtcbmV4cG9ydCAqIGZyb20gXCIuL3BhcnNlX21lZGlhX3R5cGUudHNcIjtcbmV4cG9ydCAqIGZyb20gXCIuL3R5cGVfYnlfZXh0ZW5zaW9uLnRzXCI7XG4iXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsMEVBQTBFO0FBQzFFLHFDQUFxQztBQUVyQzs7Ozs7Ozs7Ozs7O0NBWUMsR0FFRCxjQUFjLG9CQUFvQjtBQUNsQyxjQUFjLGlCQUFpQjtBQUMvQixjQUFjLDBCQUEwQjtBQUN4QyxjQUFjLHlCQUF5QjtBQUN2QyxjQUFjLG1CQUFtQjtBQUNqQyxjQUFjLHdCQUF3QjtBQUN0QyxjQUFjLHlCQUF5QiJ9