// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
import { comparatorIntersects } from "./_comparator_intersects.ts";
function rangesSatisfiable(ranges) {
  return ranges.every((r)=>{
    // For each OR at least one AND must be satisfiable
    return r.some((comparators)=>comparatorsSatisfiable(comparators));
  });
}
function comparatorsSatisfiable(comparators) {
  // Comparators are satisfiable if they all intersect with each other
  for(let i = 0; i < comparators.length - 1; i++){
    const c0 = comparators[i];
    for (const c1 of comparators.slice(i + 1)){
      if (!comparatorIntersects(c0, c1)) {
        return false;
      }
    }
  }
  return true;
}
/**
 * The ranges intersect every range of AND comparators intersects with a least one range of OR ranges.
 * @param r0 range 0
 * @param r1 range 1
 * @returns returns true if any
 */ export function rangeIntersects(r0, r1) {
  return rangesSatisfiable([
    r0,
    r1
  ]) && r0.some((r00)=>{
    return r1.some((r11)=>{
      return r00.every((c0)=>{
        return r11.every((c1)=>comparatorIntersects(c0, c1));
      });
    });
  });
}
//# sourceMappingURL=data:application/json;base64,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