// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
import { LogLevels } from "./levels.ts";
import { blue, bold, red, yellow } from "../fmt/colors.ts";
import { BaseHandler } from "./base_handler.ts";
/**
 * This is the default logger. It will output color coded log messages to the
 * console via `console.log()`.
 */ export class ConsoleHandler extends BaseHandler {
  #useColors;
  constructor(levelName, options = {}){
    super(levelName, options);
    this.#useColors = options.useColors ?? true;
  }
  format(logRecord) {
    let msg = super.format(logRecord);
    if (this.#useColors) {
      msg = this.applyColors(msg, logRecord.level);
    }
    return msg;
  }
  applyColors(msg, level) {
    switch(level){
      case LogLevels.INFO:
        msg = blue(msg);
        break;
      case LogLevels.WARN:
        msg = yellow(msg);
        break;
      case LogLevels.ERROR:
        msg = red(msg);
        break;
      case LogLevels.CRITICAL:
        msg = bold(red(msg));
        break;
      default:
        break;
    }
    return msg;
  }
  log(msg) {
    console.log(msg);
  }
}
//# sourceMappingURL=data:application/json;base64,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