// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
/**
 * Returns a new array that drops all elements in the given collection until the
 * last element that does not match the given predicate.
 *
 * @example
 * ```ts
 * import { dropLastWhile } from "https://deno.land/std@$STD_VERSION/collections/drop_last_while.ts";
 * import { assertEquals } from "https://deno.land/std@$STD_VERSION/assert/assert_equals.ts";
 *
 * const numbers = [22, 30, 44];
 *
 * const notFortyFour = dropLastWhile(numbers, (i) => i !== 44);
 *
 * assertEquals(
 *   notFortyFour,
 *   [22, 30],
 * );
 * ```
 */ export function dropLastWhile(array, predicate) {
  let offset = array.length;
  while(0 < offset && predicate(array[offset - 1]))offset--;
  return array.slice(0, offset);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAwLjIxNy4wL2NvbGxlY3Rpb25zL2Ryb3BfbGFzdF93aGlsZS50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgMjAxOC0yMDI0IHRoZSBEZW5vIGF1dGhvcnMuIEFsbCByaWdodHMgcmVzZXJ2ZWQuIE1JVCBsaWNlbnNlLlxuLy8gVGhpcyBtb2R1bGUgaXMgYnJvd3NlciBjb21wYXRpYmxlLlxuXG4vKipcbiAqIFJldHVybnMgYSBuZXcgYXJyYXkgdGhhdCBkcm9wcyBhbGwgZWxlbWVudHMgaW4gdGhlIGdpdmVuIGNvbGxlY3Rpb24gdW50aWwgdGhlXG4gKiBsYXN0IGVsZW1lbnQgdGhhdCBkb2VzIG5vdCBtYXRjaCB0aGUgZ2l2ZW4gcHJlZGljYXRlLlxuICpcbiAqIEBleGFtcGxlXG4gKiBgYGB0c1xuICogaW1wb3J0IHsgZHJvcExhc3RXaGlsZSB9IGZyb20gXCJodHRwczovL2Rlbm8ubGFuZC9zdGRAJFNURF9WRVJTSU9OL2NvbGxlY3Rpb25zL2Ryb3BfbGFzdF93aGlsZS50c1wiO1xuICogaW1wb3J0IHsgYXNzZXJ0RXF1YWxzIH0gZnJvbSBcImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAkU1REX1ZFUlNJT04vYXNzZXJ0L2Fzc2VydF9lcXVhbHMudHNcIjtcbiAqXG4gKiBjb25zdCBudW1iZXJzID0gWzIyLCAzMCwgNDRdO1xuICpcbiAqIGNvbnN0IG5vdEZvcnR5Rm91ciA9IGRyb3BMYXN0V2hpbGUobnVtYmVycywgKGkpID0+IGkgIT09IDQ0KTtcbiAqXG4gKiBhc3NlcnRFcXVhbHMoXG4gKiAgIG5vdEZvcnR5Rm91cixcbiAqICAgWzIyLCAzMF0sXG4gKiApO1xuICogYGBgXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBkcm9wTGFzdFdoaWxlPFQ+KFxuICBhcnJheTogcmVhZG9ubHkgVFtdLFxuICBwcmVkaWNhdGU6IChlbDogVCkgPT4gYm9vbGVhbixcbik6IFRbXSB7XG4gIGxldCBvZmZzZXQgPSBhcnJheS5sZW5ndGg7XG4gIHdoaWxlICgwIDwgb2Zmc2V0ICYmIHByZWRpY2F0ZShhcnJheVtvZmZzZXQgLSAxXSBhcyBUKSkgb2Zmc2V0LS07XG5cbiAgcmV0dXJuIGFycmF5LnNsaWNlKDAsIG9mZnNldCk7XG59XG4iXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsMEVBQTBFO0FBQzFFLHFDQUFxQztBQUVyQzs7Ozs7Ozs7Ozs7Ozs7Ozs7O0NBa0JDLEdBQ0QsT0FBTyxTQUFTLGNBQ2QsS0FBbUIsRUFDbkIsU0FBNkI7RUFFN0IsSUFBSSxTQUFTLE1BQU0sTUFBTTtFQUN6QixNQUFPLElBQUksVUFBVSxVQUFVLEtBQUssQ0FBQyxTQUFTLEVBQUUsRUFBUTtFQUV4RCxPQUFPLE1BQU0sS0FBSyxDQUFDLEdBQUc7QUFDeEIifQ==