// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
import { assert } from "../assert/assert.ts";
const DEFAULT_BUFFER_SIZE = 32 * 1024;
/**
 * Copy N size at the most. If read size is lesser than N, then returns nread
 * @param r Reader
 * @param dest Writer
 * @param size Read size
 *
 * @deprecated (will be removed after 1.0.0) Use the {@link https://developer.mozilla.org/en-US/docs/Web/API/Streams_API | Web Streams API} instead.
 */ export async function copyN(r, dest, size) {
  let bytesRead = 0;
  let buf = new Uint8Array(DEFAULT_BUFFER_SIZE);
  while(bytesRead < size){
    if (size - bytesRead < DEFAULT_BUFFER_SIZE) {
      buf = new Uint8Array(size - bytesRead);
    }
    const result = await r.read(buf);
    const nread = result ?? 0;
    bytesRead += nread;
    if (nread > 0) {
      let n = 0;
      while(n < nread){
        n += await dest.write(buf.slice(n, nread));
      }
      assert(n === nread, "could not write");
    }
    if (result === null) {
      break;
    }
  }
  return bytesRead;
}
//# sourceMappingURL=data:application/json;base64,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