// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
/**
 * Use this to retrieve the numeric log level by it's associated name.
 * Defaults to INFO.
 */ export const LogLevels = {
  NOTSET: 0,
  DEBUG: 10,
  INFO: 20,
  WARN: 30,
  ERROR: 40,
  CRITICAL: 50
};
/** Permitted log level names */ export const LogLevelNames = Object.keys(LogLevels).filter((key)=>isNaN(Number(key)));
const byLevel = {
  [LogLevels.NOTSET]: "NOTSET",
  [LogLevels.DEBUG]: "DEBUG",
  [LogLevels.INFO]: "INFO",
  [LogLevels.WARN]: "WARN",
  [LogLevels.ERROR]: "ERROR",
  [LogLevels.CRITICAL]: "CRITICAL"
};
/**
 * Returns the numeric log level associated with the passed,
 * stringy log level name.
 */ export function getLevelByName(name) {
  const level = LogLevels[name];
  if (level !== undefined) {
    return level;
  }
  throw new Error(`no log level found for name: ${name}`);
}
/** Returns the stringy log level name provided the numeric log level. */ export function getLevelName(level) {
  const levelName = byLevel[level];
  if (levelName) {
    return levelName;
  }
  throw new Error(`no level name found for level: ${level}`);
}
//# sourceMappingURL=data:application/json;base64,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