// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
import { toText } from "./to_text.ts";
/**
 * Converts a JSON-formatted {@linkcode ReadableSteam} of strings or
 * {@linkcode Uint8Array}s to an object. Works the same as
 * {@linkcode Response.json}.
 *
 * @example
 * ```ts
 * import { toJson } from "https://deno.land/std@$STD_VERSION/streams/to_json.ts";
 *
 * const stream = ReadableStream.from([JSON.stringify({ hello: "world" })]);
 * await toJson(stream); // { hello: "world" }
 * ```
 */ export function toJson(readableStream) {
  return toText(readableStream).then(JSON.parse);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAwLjIxNy4wL3N0cmVhbXMvdG9fanNvbi50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgMjAxOC0yMDI0IHRoZSBEZW5vIGF1dGhvcnMuIEFsbCByaWdodHMgcmVzZXJ2ZWQuIE1JVCBsaWNlbnNlLlxuLy8gVGhpcyBtb2R1bGUgaXMgYnJvd3NlciBjb21wYXRpYmxlLlxuXG5pbXBvcnQgeyB0b1RleHQgfSBmcm9tIFwiLi90b190ZXh0LnRzXCI7XG5cbi8qKlxuICogQ29udmVydHMgYSBKU09OLWZvcm1hdHRlZCB7QGxpbmtjb2RlIFJlYWRhYmxlU3RlYW19IG9mIHN0cmluZ3Mgb3JcbiAqIHtAbGlua2NvZGUgVWludDhBcnJheX1zIHRvIGFuIG9iamVjdC4gV29ya3MgdGhlIHNhbWUgYXNcbiAqIHtAbGlua2NvZGUgUmVzcG9uc2UuanNvbn0uXG4gKlxuICogQGV4YW1wbGVcbiAqIGBgYHRzXG4gKiBpbXBvcnQgeyB0b0pzb24gfSBmcm9tIFwiaHR0cHM6Ly9kZW5vLmxhbmQvc3RkQCRTVERfVkVSU0lPTi9zdHJlYW1zL3RvX2pzb24udHNcIjtcbiAqXG4gKiBjb25zdCBzdHJlYW0gPSBSZWFkYWJsZVN0cmVhbS5mcm9tKFtKU09OLnN0cmluZ2lmeSh7IGhlbGxvOiBcIndvcmxkXCIgfSldKTtcbiAqIGF3YWl0IHRvSnNvbihzdHJlYW0pOyAvLyB7IGhlbGxvOiBcIndvcmxkXCIgfVxuICogYGBgXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiB0b0pzb24oXG4gIHJlYWRhYmxlU3RyZWFtOiBSZWFkYWJsZVN0cmVhbSxcbik6IFByb21pc2U8dW5rbm93bj4ge1xuICByZXR1cm4gdG9UZXh0KHJlYWRhYmxlU3RyZWFtKS50aGVuKEpTT04ucGFyc2UpO1xufVxuIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLDBFQUEwRTtBQUMxRSxxQ0FBcUM7QUFFckMsU0FBUyxNQUFNLFFBQVEsZUFBZTtBQUV0Qzs7Ozs7Ozs7Ozs7O0NBWUMsR0FDRCxPQUFPLFNBQVMsT0FDZCxjQUE4QjtFQUU5QixPQUFPLE9BQU8sZ0JBQWdCLElBQUksQ0FBQyxLQUFLLEtBQUs7QUFDL0MifQ==