// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
import { minOf } from "./min_of.ts";
/**
 * Builds N-tuples of elements from the given N arrays with matching indices,
 * stopping when the smallest array's end is reached.
 *
 * @template T the type of the tuples produced by this function.
 * @example
 * ```ts
 * import { zip } from "https://deno.land/std@$STD_VERSION/collections/zip.ts";
 * import { assertEquals } from "https://deno.land/std@$STD_VERSION/assert/assert_equals.ts";
 *
 * const numbers = [1, 2, 3, 4];
 * const letters = ["a", "b", "c", "d"];
 * const pairs = zip(numbers, letters);
 *
 * assertEquals(
 *   pairs,
 *   [
 *     [1, "a"],
 *     [2, "b"],
 *     [3, "c"],
 *     [4, "d"],
 *   ],
 * );
 * ```
 */ export function zip(...arrays) {
  const minLength = minOf(arrays, (it)=>it.length) ?? 0;
  const ret = new Array(minLength);
  for(let i = 0; i < minLength; i += 1){
    const arr = arrays.map((it)=>it[i]);
    ret[i] = arr;
  }
  return ret;
}
//# sourceMappingURL=data:application/json;base64,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