// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
const textDecoder = new TextDecoder();
/**
 * Converts a {@linkcode ReadableSteam} of strings or {@linkcode Uint8Array}s
 * to a single string. Works the same as {@linkcode Response.text}.
 *
 * @example
 * ```ts
 * import { toText } from "https://deno.land/std@$STD_VERSION/streams/to_text.ts";
 *
 * const stream = ReadableStream.from(["Hello, ", "world!"]);
 * await toText(stream); // "Hello, world!"
 * ```
 */ export async function toText(readableStream) {
  const reader = readableStream.getReader();
  let result = "";
  while(true){
    const { done, value } = await reader.read();
    if (done) {
      break;
    }
    result += typeof value === "string" ? value : textDecoder.decode(value);
  }
  return result;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAwLjIxNy4wL3N0cmVhbXMvdG9fdGV4dC50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgMjAxOC0yMDI0IHRoZSBEZW5vIGF1dGhvcnMuIEFsbCByaWdodHMgcmVzZXJ2ZWQuIE1JVCBsaWNlbnNlLlxuLy8gVGhpcyBtb2R1bGUgaXMgYnJvd3NlciBjb21wYXRpYmxlLlxuXG5jb25zdCB0ZXh0RGVjb2RlciA9IG5ldyBUZXh0RGVjb2RlcigpO1xuXG4vKipcbiAqIENvbnZlcnRzIGEge0BsaW5rY29kZSBSZWFkYWJsZVN0ZWFtfSBvZiBzdHJpbmdzIG9yIHtAbGlua2NvZGUgVWludDhBcnJheX1zXG4gKiB0byBhIHNpbmdsZSBzdHJpbmcuIFdvcmtzIHRoZSBzYW1lIGFzIHtAbGlua2NvZGUgUmVzcG9uc2UudGV4dH0uXG4gKlxuICogQGV4YW1wbGVcbiAqIGBgYHRzXG4gKiBpbXBvcnQgeyB0b1RleHQgfSBmcm9tIFwiaHR0cHM6Ly9kZW5vLmxhbmQvc3RkQCRTVERfVkVSU0lPTi9zdHJlYW1zL3RvX3RleHQudHNcIjtcbiAqXG4gKiBjb25zdCBzdHJlYW0gPSBSZWFkYWJsZVN0cmVhbS5mcm9tKFtcIkhlbGxvLCBcIiwgXCJ3b3JsZCFcIl0pO1xuICogYXdhaXQgdG9UZXh0KHN0cmVhbSk7IC8vIFwiSGVsbG8sIHdvcmxkIVwiXG4gKiBgYGBcbiAqL1xuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIHRvVGV4dChcbiAgcmVhZGFibGVTdHJlYW06IFJlYWRhYmxlU3RyZWFtLFxuKTogUHJvbWlzZTxzdHJpbmc+IHtcbiAgY29uc3QgcmVhZGVyID0gcmVhZGFibGVTdHJlYW0uZ2V0UmVhZGVyKCk7XG4gIGxldCByZXN1bHQgPSBcIlwiO1xuXG4gIHdoaWxlICh0cnVlKSB7XG4gICAgY29uc3QgeyBkb25lLCB2YWx1ZSB9ID0gYXdhaXQgcmVhZGVyLnJlYWQoKTtcblxuICAgIGlmIChkb25lKSB7XG4gICAgICBicmVhaztcbiAgICB9XG5cbiAgICByZXN1bHQgKz0gdHlwZW9mIHZhbHVlID09PSBcInN0cmluZ1wiID8gdmFsdWUgOiB0ZXh0RGVjb2Rlci5kZWNvZGUodmFsdWUpO1xuICB9XG5cbiAgcmV0dXJuIHJlc3VsdDtcbn1cbiJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSwwRUFBMEU7QUFDMUUscUNBQXFDO0FBRXJDLE1BQU0sY0FBYyxJQUFJO0FBRXhCOzs7Ozs7Ozs7OztDQVdDLEdBQ0QsT0FBTyxlQUFlLE9BQ3BCLGNBQThCO0VBRTlCLE1BQU0sU0FBUyxlQUFlLFNBQVM7RUFDdkMsSUFBSSxTQUFTO0VBRWIsTUFBTyxLQUFNO0lBQ1gsTUFBTSxFQUFFLElBQUksRUFBRSxLQUFLLEVBQUUsR0FBRyxNQUFNLE9BQU8sSUFBSTtJQUV6QyxJQUFJLE1BQU07TUFDUjtJQUNGO0lBRUEsVUFBVSxPQUFPLFVBQVUsV0FBVyxRQUFRLFlBQVksTUFBTSxDQUFDO0VBQ25FO0VBRUEsT0FBTztBQUNUIn0=