// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
/**
 * Returns the first element that is the largest value of the given function or
 * undefined if there are no elements.
 *
 * @example
 * ```ts
 * import { maxBy } from "https://deno.land/std@$STD_VERSION/collections/max_by.ts";
 * import { assertEquals } from "https://deno.land/std@$STD_VERSION/assert/assert_equals.ts";
 *
 * const people = [
 *   { name: "Anna", age: 34 },
 *   { name: "Kim", age: 42 },
 *   { name: "John", age: 23 },
 * ];
 *
 * const personWithMaxAge = maxBy(people, (i) => i.age);
 *
 * assertEquals(personWithMaxAge, { name: "Kim", age: 42 });
 * ```
 */ export function maxBy(array, selector) {
  let max = undefined;
  let maxValue = undefined;
  for (const current of array){
    const currentValue = selector(current);
    if (maxValue === undefined || currentValue > maxValue) {
      max = current;
      maxValue = currentValue;
    }
  }
  return max;
}
//# sourceMappingURL=data:application/json;base64,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