// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
import { compareIdentifier } from "./_shared.ts";
/**
 * Returns difference between two versions by the release type, or `undefined` if the versions are the same.
 */ export function difference(s0, s1) {
  const hasPrerelease = s0.prerelease?.length || s1.prerelease?.length;
  if (s0.major !== s1.major) return hasPrerelease ? "premajor" : "major";
  if (s0.minor !== s1.minor) return hasPrerelease ? "preminor" : "minor";
  if (s0.patch !== s1.patch) return hasPrerelease ? "prepatch" : "patch";
  if (compareIdentifier(s0.prerelease, s1.prerelease) !== 0) {
    return "prerelease";
  }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAwLjIxNy4wL3NlbXZlci9kaWZmZXJlbmNlLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAyMDE4LTIwMjQgdGhlIERlbm8gYXV0aG9ycy4gQWxsIHJpZ2h0cyByZXNlcnZlZC4gTUlUIGxpY2Vuc2UuXG5pbXBvcnQgdHlwZSB7IFJlbGVhc2VUeXBlLCBTZW1WZXIgfSBmcm9tIFwiLi90eXBlcy50c1wiO1xuaW1wb3J0IHsgY29tcGFyZUlkZW50aWZpZXIgfSBmcm9tIFwiLi9fc2hhcmVkLnRzXCI7XG5cbi8qKlxuICogUmV0dXJucyBkaWZmZXJlbmNlIGJldHdlZW4gdHdvIHZlcnNpb25zIGJ5IHRoZSByZWxlYXNlIHR5cGUsIG9yIGB1bmRlZmluZWRgIGlmIHRoZSB2ZXJzaW9ucyBhcmUgdGhlIHNhbWUuXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBkaWZmZXJlbmNlKHMwOiBTZW1WZXIsIHMxOiBTZW1WZXIpOiBSZWxlYXNlVHlwZSB8IHVuZGVmaW5lZCB7XG4gIGNvbnN0IGhhc1ByZXJlbGVhc2UgPSBzMC5wcmVyZWxlYXNlPy5sZW5ndGggfHwgczEucHJlcmVsZWFzZT8ubGVuZ3RoO1xuXG4gIGlmIChzMC5tYWpvciAhPT0gczEubWFqb3IpIHJldHVybiBoYXNQcmVyZWxlYXNlID8gXCJwcmVtYWpvclwiIDogXCJtYWpvclwiO1xuICBpZiAoczAubWlub3IgIT09IHMxLm1pbm9yKSByZXR1cm4gaGFzUHJlcmVsZWFzZSA/IFwicHJlbWlub3JcIiA6IFwibWlub3JcIjtcbiAgaWYgKHMwLnBhdGNoICE9PSBzMS5wYXRjaCkgcmV0dXJuIGhhc1ByZXJlbGVhc2UgPyBcInByZXBhdGNoXCIgOiBcInBhdGNoXCI7XG5cbiAgaWYgKGNvbXBhcmVJZGVudGlmaWVyKHMwLnByZXJlbGVhc2UsIHMxLnByZXJlbGVhc2UpICE9PSAwKSB7XG4gICAgcmV0dXJuIFwicHJlcmVsZWFzZVwiO1xuICB9XG59XG4iXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsMEVBQTBFO0FBRTFFLFNBQVMsaUJBQWlCLFFBQVEsZUFBZTtBQUVqRDs7Q0FFQyxHQUNELE9BQU8sU0FBUyxXQUFXLEVBQVUsRUFBRSxFQUFVO0VBQy9DLE1BQU0sZ0JBQWdCLEdBQUcsVUFBVSxFQUFFLFVBQVUsR0FBRyxVQUFVLEVBQUU7RUFFOUQsSUFBSSxHQUFHLEtBQUssS0FBSyxHQUFHLEtBQUssRUFBRSxPQUFPLGdCQUFnQixhQUFhO0VBQy9ELElBQUksR0FBRyxLQUFLLEtBQUssR0FBRyxLQUFLLEVBQUUsT0FBTyxnQkFBZ0IsYUFBYTtFQUMvRCxJQUFJLEdBQUcsS0FBSyxLQUFLLEdBQUcsS0FBSyxFQUFFLE9BQU8sZ0JBQWdCLGFBQWE7RUFFL0QsSUFBSSxrQkFBa0IsR0FBRyxVQUFVLEVBQUUsR0FBRyxVQUFVLE1BQU0sR0FBRztJQUN6RCxPQUFPO0VBQ1Q7QUFDRiJ9