// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
/**
 * Reader utility for combining multiple readers
 *
 * @deprecated (will be removed after 1.0.0) Use the {@link https://developer.mozilla.org/en-US/docs/Web/API/Streams_API | Web Streams API} instead.
 */ export class MultiReader {
  #readers;
  #currentIndex = 0;
  constructor(readers){
    this.#readers = [
      ...readers
    ];
  }
  async read(p) {
    const r = this.#readers[this.#currentIndex];
    if (!r) return null;
    const result = await r.read(p);
    if (result === null) {
      this.#currentIndex++;
      return 0;
    }
    return result;
  }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAwLjIxNy4wL2lvL211bHRpX3JlYWRlci50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgMjAxOC0yMDI0IHRoZSBEZW5vIGF1dGhvcnMuIEFsbCByaWdodHMgcmVzZXJ2ZWQuIE1JVCBsaWNlbnNlLlxuLy8gVGhpcyBtb2R1bGUgaXMgYnJvd3NlciBjb21wYXRpYmxlLlxuXG5pbXBvcnQgdHlwZSB7IFJlYWRlciB9IGZyb20gXCIuL3R5cGVzLnRzXCI7XG5cbi8qKlxuICogUmVhZGVyIHV0aWxpdHkgZm9yIGNvbWJpbmluZyBtdWx0aXBsZSByZWFkZXJzXG4gKlxuICogQGRlcHJlY2F0ZWQgKHdpbGwgYmUgcmVtb3ZlZCBhZnRlciAxLjAuMCkgVXNlIHRoZSB7QGxpbmsgaHR0cHM6Ly9kZXZlbG9wZXIubW96aWxsYS5vcmcvZW4tVVMvZG9jcy9XZWIvQVBJL1N0cmVhbXNfQVBJIHwgV2ViIFN0cmVhbXMgQVBJfSBpbnN0ZWFkLlxuICovXG5leHBvcnQgY2xhc3MgTXVsdGlSZWFkZXIgaW1wbGVtZW50cyBSZWFkZXIge1xuICByZWFkb25seSAjcmVhZGVyczogUmVhZGVyW107XG4gICNjdXJyZW50SW5kZXggPSAwO1xuXG4gIGNvbnN0cnVjdG9yKHJlYWRlcnM6IFJlYWRlcltdKSB7XG4gICAgdGhpcy4jcmVhZGVycyA9IFsuLi5yZWFkZXJzXTtcbiAgfVxuXG4gIGFzeW5jIHJlYWQocDogVWludDhBcnJheSk6IFByb21pc2U8bnVtYmVyIHwgbnVsbD4ge1xuICAgIGNvbnN0IHIgPSB0aGlzLiNyZWFkZXJzW3RoaXMuI2N1cnJlbnRJbmRleF07XG4gICAgaWYgKCFyKSByZXR1cm4gbnVsbDtcbiAgICBjb25zdCByZXN1bHQgPSBhd2FpdCByLnJlYWQocCk7XG4gICAgaWYgKHJlc3VsdCA9PT0gbnVsbCkge1xuICAgICAgdGhpcy4jY3VycmVudEluZGV4Kys7XG4gICAgICByZXR1cm4gMDtcbiAgICB9XG4gICAgcmV0dXJuIHJlc3VsdDtcbiAgfVxufVxuIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLDBFQUEwRTtBQUMxRSxxQ0FBcUM7QUFJckM7Ozs7Q0FJQyxHQUNELE9BQU8sTUFBTTtFQUNGLENBQUMsT0FBTyxDQUFXO0VBQzVCLENBQUMsWUFBWSxHQUFHLEVBQUU7RUFFbEIsWUFBWSxPQUFpQixDQUFFO0lBQzdCLElBQUksQ0FBQyxDQUFDLE9BQU8sR0FBRztTQUFJO0tBQVE7RUFDOUI7RUFFQSxNQUFNLEtBQUssQ0FBYSxFQUEwQjtJQUNoRCxNQUFNLElBQUksSUFBSSxDQUFDLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDLFlBQVksQ0FBQztJQUMzQyxJQUFJLENBQUMsR0FBRyxPQUFPO0lBQ2YsTUFBTSxTQUFTLE1BQU0sRUFBRSxJQUFJLENBQUM7SUFDNUIsSUFBSSxXQUFXLE1BQU07TUFDbkIsSUFBSSxDQUFDLENBQUMsWUFBWTtNQUNsQixPQUFPO0lBQ1Q7SUFDQSxPQUFPO0VBQ1Q7QUFDRiJ9