// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
import db from "./vendor/mime-db.v1.52.0.ts";
/** A map of the media type for a given extension */ export const types = new Map();
/** A map of extensions for a given media type. */ const extensions = new Map();
/** Internal function to populate the maps based on the Mime DB. */ const preference = [
  "nginx",
  "apache",
  undefined,
  "iana"
];
for (const type of Object.keys(db)){
  const mime = db[type];
  const exts = mime.extensions;
  if (!exts || !exts.length) {
    continue;
  }
  // @ts-ignore work around denoland/dnt#148
  extensions.set(type, exts);
  for (const ext of exts){
    const current = types.get(ext);
    if (current) {
      const from = preference.indexOf(db[current].source);
      const to = preference.indexOf(mime.source);
      if (current !== "application/octet-stream" && (from > to || // @ts-ignore work around denoland/dnt#148
      from === to && current.startsWith("application/"))) {
        continue;
      }
    }
    types.set(ext, type);
  }
}
export { db, extensions };
//# sourceMappingURL=data:application/json;base64,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