// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
/**
 * Create a {@linkcode Writer} from a {@linkcode WritableStreamDefaultWriter}.
 *
 * @example
 * ```ts
 * import { copy } from "https://deno.land/std@$STD_VERSION/io/copy.ts";
 * import { writerFromStreamWriter } from "https://deno.land/std@$STD_VERSION/streams/writer_from_stream_writer.ts";
 *
 * using file = await Deno.open("./deno.land.html", { read: true });
 *
 * const writableStream = new WritableStream({
 *   write(chunk): void {
 *     console.log(chunk);
 *   },
 * });
 * const writer = writerFromStreamWriter(writableStream.getWriter());
 * await copy(file, writer);
 * ```
 *
 * @deprecated (will be removed after 1.0.0) Use {@linkcode WritableStreamDefaultWriter} directly.
 */ export function writerFromStreamWriter(streamWriter) {
  return {
    async write (p) {
      await streamWriter.ready;
      await streamWriter.write(p);
      return p.length;
    }
  };
}
//# sourceMappingURL=data:application/json;base64,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