// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
export function jsonFormatter(logRecord) {
  return JSON.stringify({
    level: logRecord.levelName,
    datetime: logRecord.datetime.getTime(),
    message: logRecord.msg,
    args: flattenArgs(logRecord.args)
  });
}
function flattenArgs(args) {
  if (args.length === 1) {
    return args[0];
  } else if (args.length > 1) {
    return args;
  }
}
export const formatters = {
  jsonFormatter
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAwLjIxNy4wL2xvZy9mb3JtYXR0ZXJzLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAyMDE4LTIwMjQgdGhlIERlbm8gYXV0aG9ycy4gQWxsIHJpZ2h0cyByZXNlcnZlZC4gTUlUIGxpY2Vuc2UuXG5pbXBvcnQgeyBMb2dSZWNvcmQgfSBmcm9tIFwiLi9sb2dnZXIudHNcIjtcblxuZXhwb3J0IGZ1bmN0aW9uIGpzb25Gb3JtYXR0ZXIobG9nUmVjb3JkOiBMb2dSZWNvcmQpOiBzdHJpbmcge1xuICByZXR1cm4gSlNPTi5zdHJpbmdpZnkoe1xuICAgIGxldmVsOiBsb2dSZWNvcmQubGV2ZWxOYW1lLFxuICAgIGRhdGV0aW1lOiBsb2dSZWNvcmQuZGF0ZXRpbWUuZ2V0VGltZSgpLFxuICAgIG1lc3NhZ2U6IGxvZ1JlY29yZC5tc2csXG4gICAgYXJnczogZmxhdHRlbkFyZ3MobG9nUmVjb3JkLmFyZ3MpLFxuICB9KTtcbn1cblxuZnVuY3Rpb24gZmxhdHRlbkFyZ3MoYXJnczogdW5rbm93bltdKTogdW5rbm93biB7XG4gIGlmIChhcmdzLmxlbmd0aCA9PT0gMSkge1xuICAgIHJldHVybiBhcmdzWzBdO1xuICB9IGVsc2UgaWYgKGFyZ3MubGVuZ3RoID4gMSkge1xuICAgIHJldHVybiBhcmdzO1xuICB9XG59XG5cbmV4cG9ydCBjb25zdCBmb3JtYXR0ZXJzOiB7XG4gIGpzb25Gb3JtYXR0ZXIobG9nUmVjb3JkOiBMb2dSZWNvcmQpOiBzdHJpbmc7XG59ID0ge1xuICBqc29uRm9ybWF0dGVyLFxufTtcbiJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSwwRUFBMEU7QUFHMUUsT0FBTyxTQUFTLGNBQWMsU0FBb0I7RUFDaEQsT0FBTyxLQUFLLFNBQVMsQ0FBQztJQUNwQixPQUFPLFVBQVUsU0FBUztJQUMxQixVQUFVLFVBQVUsUUFBUSxDQUFDLE9BQU87SUFDcEMsU0FBUyxVQUFVLEdBQUc7SUFDdEIsTUFBTSxZQUFZLFVBQVUsSUFBSTtFQUNsQztBQUNGO0FBRUEsU0FBUyxZQUFZLElBQWU7RUFDbEMsSUFBSSxLQUFLLE1BQU0sS0FBSyxHQUFHO0lBQ3JCLE9BQU8sSUFBSSxDQUFDLEVBQUU7RUFDaEIsT0FBTyxJQUFJLEtBQUssTUFBTSxHQUFHLEdBQUc7SUFDMUIsT0FBTztFQUNUO0FBQ0Y7QUFFQSxPQUFPLE1BQU0sYUFFVDtFQUNGO0FBQ0YsRUFBRSJ9