// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
import { PartialReadError } from "../io/buf_reader.ts";
export var FileTypes;
(function(FileTypes) {
  FileTypes[FileTypes["file"] = 0] = "file";
  FileTypes[FileTypes["link"] = 1] = "link";
  FileTypes[FileTypes["symlink"] = 2] = "symlink";
  FileTypes[FileTypes["character-device"] = 3] = "character-device";
  FileTypes[FileTypes["block-device"] = 4] = "block-device";
  FileTypes[FileTypes["directory"] = 5] = "directory";
  FileTypes[FileTypes["fifo"] = 6] = "fifo";
  FileTypes[FileTypes["contiguous-file"] = 7] = "contiguous-file";
})(FileTypes || (FileTypes = {}));
export const HEADER_LENGTH = 512;
/*
struct posix_header {           // byte offset
  char name[100];               //   0
  char mode[8];                 // 100
  char uid[8];                  // 108
  char gid[8];                  // 116
  char size[12];                // 124
  char mtime[12];               // 136
  char chksum[8];               // 148
  char typeflag;                // 156
  char linkname[100];           // 157
  char magic[6];                // 257
  char version[2];              // 263
  char uname[32];               // 265
  char gname[32];               // 297
  char devmajor[8];             // 329
  char devminor[8];             // 337
  char prefix[155];             // 345
                                // 500
};
*/ export const ustarStructure = [
  {
    field: "fileName",
    length: 100
  },
  {
    field: "fileMode",
    length: 8
  },
  {
    field: "uid",
    length: 8
  },
  {
    field: "gid",
    length: 8
  },
  {
    field: "fileSize",
    length: 12
  },
  {
    field: "mtime",
    length: 12
  },
  {
    field: "checksum",
    length: 8
  },
  {
    field: "type",
    length: 1
  },
  {
    field: "linkName",
    length: 100
  },
  {
    field: "ustar",
    length: 8
  },
  {
    field: "owner",
    length: 32
  },
  {
    field: "group",
    length: 32
  },
  {
    field: "majorNumber",
    length: 8
  },
  {
    field: "minorNumber",
    length: 8
  },
  {
    field: "fileNamePrefix",
    length: 155
  },
  {
    field: "padding",
    length: 12
  }
];
export async function readBlock(reader, p) {
  let bytesRead = 0;
  while(bytesRead < p.length){
    const rr = await reader.read(p.subarray(bytesRead));
    if (rr === null) {
      if (bytesRead === 0) {
        return null;
      } else {
        throw new PartialReadError();
      }
    }
    bytesRead += rr;
  }
  return bytesRead;
}
//# sourceMappingURL=data:application/json;base64,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