// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
import { parseMediaType } from "./parse_media_type.ts";
import { extensions } from "./_db.ts";
export { extensions };
/**
 * Returns the extensions known to be associated with the media type `type`.
 * When `type` has no associated extensions, the function returns `undefined`.
 *
 * Extensions are returned without a leading `.`.
 *
 * @example
 * ```ts
 * import { extensionsByType } from "https://deno.land/std@$STD_VERSION/media_types/extensions_by_type.ts";
 *
 * extensionsByType("application/json"); // ["json", "map"]
 * extensionsByType("text/html; charset=UTF-8"); // ["html", "htm", "shtml"]
 * extensionsByType("application/foo"); // undefined
 * ```
 */ export function extensionsByType(type) {
  try {
    const [mediaType] = parseMediaType(type);
    return extensions.get(mediaType);
  } catch  {
  // just swallow errors, returning undefined
  }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAwLjIxNy4wL21lZGlhX3R5cGVzL2V4dGVuc2lvbnNfYnlfdHlwZS50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgMjAxOC0yMDI0IHRoZSBEZW5vIGF1dGhvcnMuIEFsbCByaWdodHMgcmVzZXJ2ZWQuIE1JVCBsaWNlbnNlLlxuLy8gVGhpcyBtb2R1bGUgaXMgYnJvd3NlciBjb21wYXRpYmxlLlxuXG5pbXBvcnQgeyBwYXJzZU1lZGlhVHlwZSB9IGZyb20gXCIuL3BhcnNlX21lZGlhX3R5cGUudHNcIjtcbmltcG9ydCB7IGV4dGVuc2lvbnMgfSBmcm9tIFwiLi9fZGIudHNcIjtcblxuZXhwb3J0IHsgZXh0ZW5zaW9ucyB9O1xuXG4vKipcbiAqIFJldHVybnMgdGhlIGV4dGVuc2lvbnMga25vd24gdG8gYmUgYXNzb2NpYXRlZCB3aXRoIHRoZSBtZWRpYSB0eXBlIGB0eXBlYC5cbiAqIFdoZW4gYHR5cGVgIGhhcyBubyBhc3NvY2lhdGVkIGV4dGVuc2lvbnMsIHRoZSBmdW5jdGlvbiByZXR1cm5zIGB1bmRlZmluZWRgLlxuICpcbiAqIEV4dGVuc2lvbnMgYXJlIHJldHVybmVkIHdpdGhvdXQgYSBsZWFkaW5nIGAuYC5cbiAqXG4gKiBAZXhhbXBsZVxuICogYGBgdHNcbiAqIGltcG9ydCB7IGV4dGVuc2lvbnNCeVR5cGUgfSBmcm9tIFwiaHR0cHM6Ly9kZW5vLmxhbmQvc3RkQCRTVERfVkVSU0lPTi9tZWRpYV90eXBlcy9leHRlbnNpb25zX2J5X3R5cGUudHNcIjtcbiAqXG4gKiBleHRlbnNpb25zQnlUeXBlKFwiYXBwbGljYXRpb24vanNvblwiKTsgLy8gW1wianNvblwiLCBcIm1hcFwiXVxuICogZXh0ZW5zaW9uc0J5VHlwZShcInRleHQvaHRtbDsgY2hhcnNldD1VVEYtOFwiKTsgLy8gW1wiaHRtbFwiLCBcImh0bVwiLCBcInNodG1sXCJdXG4gKiBleHRlbnNpb25zQnlUeXBlKFwiYXBwbGljYXRpb24vZm9vXCIpOyAvLyB1bmRlZmluZWRcbiAqIGBgYFxuICovXG5leHBvcnQgZnVuY3Rpb24gZXh0ZW5zaW9uc0J5VHlwZSh0eXBlOiBzdHJpbmcpOiBzdHJpbmdbXSB8IHVuZGVmaW5lZCB7XG4gIHRyeSB7XG4gICAgY29uc3QgW21lZGlhVHlwZV0gPSBwYXJzZU1lZGlhVHlwZSh0eXBlKTtcbiAgICByZXR1cm4gZXh0ZW5zaW9ucy5nZXQobWVkaWFUeXBlKTtcbiAgfSBjYXRjaCB7XG4gICAgLy8ganVzdCBzd2FsbG93IGVycm9ycywgcmV0dXJuaW5nIHVuZGVmaW5lZFxuICB9XG59XG4iXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsMEVBQTBFO0FBQzFFLHFDQUFxQztBQUVyQyxTQUFTLGNBQWMsUUFBUSx3QkFBd0I7QUFDdkQsU0FBUyxVQUFVLFFBQVEsV0FBVztBQUV0QyxTQUFTLFVBQVUsR0FBRztBQUV0Qjs7Ozs7Ozs7Ozs7Ozs7Q0FjQyxHQUNELE9BQU8sU0FBUyxpQkFBaUIsSUFBWTtFQUMzQyxJQUFJO0lBQ0YsTUFBTSxDQUFDLFVBQVUsR0FBRyxlQUFlO0lBQ25DLE9BQU8sV0FBVyxHQUFHLENBQUM7RUFDeEIsRUFBRSxPQUFNO0VBQ04sMkNBQTJDO0VBQzdDO0FBQ0YifQ==