// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
import { readInt } from "./read_int.ts";
const MAX_SAFE_INTEGER = BigInt(Number.MAX_SAFE_INTEGER);
/**
 * Read big endian 64bit long from BufReader
 * @param buf
 *
 * @deprecated (will be removed after 1.0.0) Use the {@link https://developer.mozilla.org/en-US/docs/Web/API/Streams_API | Web Streams API} instead.
 */ export async function readLong(buf) {
  const high = await readInt(buf);
  if (high === null) return null;
  const low = await readInt(buf);
  if (low === null) throw new Deno.errors.UnexpectedEof();
  const big = BigInt(high) << 32n | BigInt(low);
  // We probably should provide a similar API that returns BigInt values.
  if (big > MAX_SAFE_INTEGER) {
    throw new RangeError("Long value too big to be represented as a JavaScript number.");
  }
  return Number(big);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAwLjIxNy4wL2lvL3JlYWRfbG9uZy50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgMjAxOC0yMDI0IHRoZSBEZW5vIGF1dGhvcnMuIEFsbCByaWdodHMgcmVzZXJ2ZWQuIE1JVCBsaWNlbnNlLlxuXG5pbXBvcnQgeyB0eXBlIEJ1ZlJlYWRlciB9IGZyb20gXCIuL2J1Zl9yZWFkZXIudHNcIjtcbmltcG9ydCB7IHJlYWRJbnQgfSBmcm9tIFwiLi9yZWFkX2ludC50c1wiO1xuXG5jb25zdCBNQVhfU0FGRV9JTlRFR0VSID0gQmlnSW50KE51bWJlci5NQVhfU0FGRV9JTlRFR0VSKTtcblxuLyoqXG4gKiBSZWFkIGJpZyBlbmRpYW4gNjRiaXQgbG9uZyBmcm9tIEJ1ZlJlYWRlclxuICogQHBhcmFtIGJ1ZlxuICpcbiAqIEBkZXByZWNhdGVkICh3aWxsIGJlIHJlbW92ZWQgYWZ0ZXIgMS4wLjApIFVzZSB0aGUge0BsaW5rIGh0dHBzOi8vZGV2ZWxvcGVyLm1vemlsbGEub3JnL2VuLVVTL2RvY3MvV2ViL0FQSS9TdHJlYW1zX0FQSSB8IFdlYiBTdHJlYW1zIEFQSX0gaW5zdGVhZC5cbiAqL1xuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIHJlYWRMb25nKGJ1ZjogQnVmUmVhZGVyKTogUHJvbWlzZTxudW1iZXIgfCBudWxsPiB7XG4gIGNvbnN0IGhpZ2ggPSBhd2FpdCByZWFkSW50KGJ1Zik7XG4gIGlmIChoaWdoID09PSBudWxsKSByZXR1cm4gbnVsbDtcbiAgY29uc3QgbG93ID0gYXdhaXQgcmVhZEludChidWYpO1xuICBpZiAobG93ID09PSBudWxsKSB0aHJvdyBuZXcgRGVuby5lcnJvcnMuVW5leHBlY3RlZEVvZigpO1xuICBjb25zdCBiaWcgPSAoQmlnSW50KGhpZ2gpIDw8IDMybikgfCBCaWdJbnQobG93KTtcbiAgLy8gV2UgcHJvYmFibHkgc2hvdWxkIHByb3ZpZGUgYSBzaW1pbGFyIEFQSSB0aGF0IHJldHVybnMgQmlnSW50IHZhbHVlcy5cbiAgaWYgKGJpZyA+IE1BWF9TQUZFX0lOVEVHRVIpIHtcbiAgICB0aHJvdyBuZXcgUmFuZ2VFcnJvcihcbiAgICAgIFwiTG9uZyB2YWx1ZSB0b28gYmlnIHRvIGJlIHJlcHJlc2VudGVkIGFzIGEgSmF2YVNjcmlwdCBudW1iZXIuXCIsXG4gICAgKTtcbiAgfVxuICByZXR1cm4gTnVtYmVyKGJpZyk7XG59XG4iXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsMEVBQTBFO0FBRzFFLFNBQVMsT0FBTyxRQUFRLGdCQUFnQjtBQUV4QyxNQUFNLG1CQUFtQixPQUFPLE9BQU8sZ0JBQWdCO0FBRXZEOzs7OztDQUtDLEdBQ0QsT0FBTyxlQUFlLFNBQVMsR0FBYztFQUMzQyxNQUFNLE9BQU8sTUFBTSxRQUFRO0VBQzNCLElBQUksU0FBUyxNQUFNLE9BQU87RUFDMUIsTUFBTSxNQUFNLE1BQU0sUUFBUTtFQUMxQixJQUFJLFFBQVEsTUFBTSxNQUFNLElBQUksS0FBSyxNQUFNLENBQUMsYUFBYTtFQUNyRCxNQUFNLE1BQU0sQUFBQyxPQUFPLFNBQVMsR0FBRyxHQUFJLE9BQU87RUFDM0MsdUVBQXVFO0VBQ3ZFLElBQUksTUFBTSxrQkFBa0I7SUFDMUIsTUFBTSxJQUFJLFdBQ1I7RUFFSjtFQUNBLE9BQU8sT0FBTztBQUNoQiJ9