// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
/**
 * Helpers for interacting with Deno's permissions system.
 * @module
 * @deprecated (will be removed in 1.0.0) Use the {@link https://deno.land/api?s=Deno.Permissions | Deno Permissions API} directly instead.
 */ const { PermissionDenied } = Deno.errors;
function getPermissionString(descriptors) {
  return descriptors.length ? `  ${descriptors.map((pd)=>{
    switch(pd.name){
      case "read":
      case "write":
        return pd.path ? `--allow-${pd.name}=${pd.path}` : `--allow-${pd.name}`;
      case "net":
        return pd.host ? `--allow-${pd.name}=${pd.host}` : `--allow-${pd.name}`;
      default:
        return `--allow-${pd.name}`;
    }
  }).join("\n  ")}` : "";
}
export async function grant(descriptor, ...descriptors) {
  const result = [];
  descriptors = Array.isArray(descriptor) ? descriptor : [
    descriptor,
    ...descriptors
  ];
  for (const descriptor of descriptors){
    let state = (await Deno.permissions.query(descriptor)).state;
    if (state === "prompt") {
      state = (await Deno.permissions.request(descriptor)).state;
    }
    if (state === "granted") {
      result.push(descriptor);
    }
  }
  return result.length ? result : undefined;
}
export async function grantOrThrow(descriptor, ...descriptors) {
  const denied = [];
  descriptors = Array.isArray(descriptor) ? descriptor : [
    descriptor,
    ...descriptors
  ];
  for (const descriptor of descriptors){
    const { state } = await Deno.permissions.request(descriptor);
    if (state !== "granted") {
      denied.push(descriptor);
    }
  }
  if (denied.length) {
    throw new PermissionDenied(`The following permissions have not been granted:\n${getPermissionString(denied)}`);
  }
}
//# sourceMappingURL=data:application/json;base64,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