// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
import { COMPARATOR_REGEXP, parseBuild, parseNumber, parsePrerelease } from "./_shared.ts";
import { ANY, NONE } from "./constants.ts";
/**
 * Parses a comparator string into a valid Comparator.
 * @param comparator
 * @returns A valid Comparator
 */ export function parseComparator(comparator) {
  const match = comparator.match(COMPARATOR_REGEXP);
  const groups = match?.groups;
  if (!groups) return NONE;
  const { operator, prerelease, buildmetadata } = groups;
  const semver = groups.major ? {
    major: parseNumber(groups.major, "Invalid major version"),
    minor: parseNumber(groups.minor, "Invalid minor version"),
    patch: parseNumber(groups.patch, "Invalid patch version"),
    prerelease: prerelease ? parsePrerelease(prerelease) : [],
    build: buildmetadata ? parseBuild(buildmetadata) : []
  } : ANY;
  return {
    operator: operator || undefined,
    ...semver,
    semver
  };
}
//# sourceMappingURL=data:application/json;base64,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