// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
/**
 * Contains the functions {@linkcode accepts}, {@linkcode acceptsEncodings}, and
 * {@linkcode acceptsLanguages} to provide content negotiation capabilities.
 *
 * @module
 */ import { preferredEncodings } from "./_negotiation/encoding.ts";
import { preferredLanguages } from "./_negotiation/language.ts";
import { preferredMediaTypes } from "./_negotiation/media_type.ts";
export function accepts(request, ...types) {
  const accept = request.headers.get("accept");
  return types.length ? accept ? preferredMediaTypes(accept, types)[0] : types[0] : accept ? preferredMediaTypes(accept) : [
    "*/*"
  ];
}
export function acceptsEncodings(request, ...encodings) {
  const acceptEncoding = request.headers.get("accept-encoding");
  return encodings.length ? acceptEncoding ? preferredEncodings(acceptEncoding, encodings)[0] : encodings[0] : acceptEncoding ? preferredEncodings(acceptEncoding) : [
    "*"
  ];
}
export function acceptsLanguages(request, ...langs) {
  const acceptLanguage = request.headers.get("accept-language");
  return langs.length ? acceptLanguage ? preferredLanguages(acceptLanguage, langs)[0] : langs[0] : acceptLanguage ? preferredLanguages(acceptLanguage) : [
    "*"
  ];
}
//# sourceMappingURL=data:application/json;base64,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