// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
/**
 * Slice number into 64bit big endian byte array
 * @param d The number to be sliced
 * @param dest The sliced array
 *
 * @deprecated (will be removed after 1.0.0) Use the {@link https://developer.mozilla.org/en-US/docs/Web/API/Streams_API | Web Streams API} instead.
 */ export function sliceLongToBytes(d, dest = Array.from({
  length: 8
})) {
  let big = BigInt(d);
  for(let i = 0; i < 8; i++){
    dest[7 - i] = Number(big & 0xffn);
    big >>= 8n;
  }
  return dest;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAwLjIxNy4wL2lvL3NsaWNlX2xvbmdfdG9fYnl0ZXMudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IDIwMTgtMjAyNCB0aGUgRGVubyBhdXRob3JzLiBBbGwgcmlnaHRzIHJlc2VydmVkLiBNSVQgbGljZW5zZS5cbi8vIFRoaXMgbW9kdWxlIGlzIGJyb3dzZXIgY29tcGF0aWJsZS5cblxuLyoqXG4gKiBTbGljZSBudW1iZXIgaW50byA2NGJpdCBiaWcgZW5kaWFuIGJ5dGUgYXJyYXlcbiAqIEBwYXJhbSBkIFRoZSBudW1iZXIgdG8gYmUgc2xpY2VkXG4gKiBAcGFyYW0gZGVzdCBUaGUgc2xpY2VkIGFycmF5XG4gKlxuICogQGRlcHJlY2F0ZWQgKHdpbGwgYmUgcmVtb3ZlZCBhZnRlciAxLjAuMCkgVXNlIHRoZSB7QGxpbmsgaHR0cHM6Ly9kZXZlbG9wZXIubW96aWxsYS5vcmcvZW4tVVMvZG9jcy9XZWIvQVBJL1N0cmVhbXNfQVBJIHwgV2ViIFN0cmVhbXMgQVBJfSBpbnN0ZWFkLlxuICovXG5leHBvcnQgZnVuY3Rpb24gc2xpY2VMb25nVG9CeXRlcyhcbiAgZDogbnVtYmVyLFxuICBkZXN0OiBudW1iZXJbXSA9IEFycmF5LmZyb208bnVtYmVyPih7IGxlbmd0aDogOCB9KSxcbik6IG51bWJlcltdIHtcbiAgbGV0IGJpZyA9IEJpZ0ludChkKTtcbiAgZm9yIChsZXQgaSA9IDA7IGkgPCA4OyBpKyspIHtcbiAgICBkZXN0WzcgLSBpXSA9IE51bWJlcihiaWcgJiAweGZmbik7XG4gICAgYmlnID4+PSA4bjtcbiAgfVxuICByZXR1cm4gZGVzdDtcbn1cbiJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSwwRUFBMEU7QUFDMUUscUNBQXFDO0FBRXJDOzs7Ozs7Q0FNQyxHQUNELE9BQU8sU0FBUyxpQkFDZCxDQUFTLEVBQ1QsT0FBaUIsTUFBTSxJQUFJLENBQVM7RUFBRSxRQUFRO0FBQUUsRUFBRTtFQUVsRCxJQUFJLE1BQU0sT0FBTztFQUNqQixJQUFLLElBQUksSUFBSSxHQUFHLElBQUksR0FBRyxJQUFLO0lBQzFCLElBQUksQ0FBQyxJQUFJLEVBQUUsR0FBRyxPQUFPLE1BQU0sS0FBSztJQUNoQyxRQUFRLEVBQUU7RUFDWjtFQUNBLE9BQU87QUFDVCJ9