// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
/** Order option for {@linkcode SortByOptions}. */ export function sortBy(array, selector, options) {
  const len = array.length;
  const indexes = new Array(len);
  const selectors = new Array(len);
  const order = options?.order ?? "asc";
  array.forEach((item, idx)=>{
    indexes[idx] = idx;
    const s = selector(item);
    selectors[idx] = Number.isNaN(s) ? null : s;
  });
  indexes.sort((ai, bi)=>{
    let a = selectors[ai];
    let b = selectors[bi];
    if (order === "desc") {
      [a, b] = [
        b,
        a
      ];
    }
    if (a === null) return 1;
    if (b === null) return -1;
    return a > b ? 1 : a < b ? -1 : 0;
  });
  for(let i = 0; i < len; i++){
    indexes[i] = array[indexes[i]];
  }
  return indexes;
}
//# sourceMappingURL=data:application/json;base64,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