// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
import { readerFromStreamReader as _readerFromStreamReader } from "../io/reader_from_stream_reader.ts";
/**
 * Create a {@linkcode Reader} from a {@linkcode ReadableStreamDefaultReader}.
 *
 * @example
 * ```ts
 * import { copy } from "https://deno.land/std@$STD_VERSION/io/copy.ts";
 * import { readerFromStreamReader } from "https://deno.land/std@$STD_VERSION/streams/reader_from_stream_reader.ts";
 *
 * const res = await fetch("https://deno.land");
 * using file = await Deno.open("./deno.land.html", { create: true, write: true });
 *
 * const reader = readerFromStreamReader(res.body!.getReader());
 * await copy(reader, file);
 * ```
 *
 * @deprecated (will be removed in 1.0.0) Import from {@link https://deno.land/std/io/reader_from_stream_reader.ts} instead.
 */ export function readerFromStreamReader(streamReader) {
  return _readerFromStreamReader(streamReader);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAwLjIxNy4wL3N0cmVhbXMvcmVhZGVyX2Zyb21fc3RyZWFtX3JlYWRlci50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgMjAxOC0yMDI0IHRoZSBEZW5vIGF1dGhvcnMuIEFsbCByaWdodHMgcmVzZXJ2ZWQuIE1JVCBsaWNlbnNlLlxuLy8gVGhpcyBtb2R1bGUgaXMgYnJvd3NlciBjb21wYXRpYmxlLlxuXG5pbXBvcnQgeyByZWFkZXJGcm9tU3RyZWFtUmVhZGVyIGFzIF9yZWFkZXJGcm9tU3RyZWFtUmVhZGVyIH0gZnJvbSBcIi4uL2lvL3JlYWRlcl9mcm9tX3N0cmVhbV9yZWFkZXIudHNcIjtcbmltcG9ydCB0eXBlIHsgUmVhZGVyIH0gZnJvbSBcIi4uL2lvL3R5cGVzLnRzXCI7XG5cbi8qKlxuICogQ3JlYXRlIGEge0BsaW5rY29kZSBSZWFkZXJ9IGZyb20gYSB7QGxpbmtjb2RlIFJlYWRhYmxlU3RyZWFtRGVmYXVsdFJlYWRlcn0uXG4gKlxuICogQGV4YW1wbGVcbiAqIGBgYHRzXG4gKiBpbXBvcnQgeyBjb3B5IH0gZnJvbSBcImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAkU1REX1ZFUlNJT04vaW8vY29weS50c1wiO1xuICogaW1wb3J0IHsgcmVhZGVyRnJvbVN0cmVhbVJlYWRlciB9IGZyb20gXCJodHRwczovL2Rlbm8ubGFuZC9zdGRAJFNURF9WRVJTSU9OL3N0cmVhbXMvcmVhZGVyX2Zyb21fc3RyZWFtX3JlYWRlci50c1wiO1xuICpcbiAqIGNvbnN0IHJlcyA9IGF3YWl0IGZldGNoKFwiaHR0cHM6Ly9kZW5vLmxhbmRcIik7XG4gKiB1c2luZyBmaWxlID0gYXdhaXQgRGVuby5vcGVuKFwiLi9kZW5vLmxhbmQuaHRtbFwiLCB7IGNyZWF0ZTogdHJ1ZSwgd3JpdGU6IHRydWUgfSk7XG4gKlxuICogY29uc3QgcmVhZGVyID0gcmVhZGVyRnJvbVN0cmVhbVJlYWRlcihyZXMuYm9keSEuZ2V0UmVhZGVyKCkpO1xuICogYXdhaXQgY29weShyZWFkZXIsIGZpbGUpO1xuICogYGBgXG4gKlxuICogQGRlcHJlY2F0ZWQgKHdpbGwgYmUgcmVtb3ZlZCBpbiAxLjAuMCkgSW1wb3J0IGZyb20ge0BsaW5rIGh0dHBzOi8vZGVuby5sYW5kL3N0ZC9pby9yZWFkZXJfZnJvbV9zdHJlYW1fcmVhZGVyLnRzfSBpbnN0ZWFkLlxuICovXG5leHBvcnQgZnVuY3Rpb24gcmVhZGVyRnJvbVN0cmVhbVJlYWRlcihcbiAgc3RyZWFtUmVhZGVyOiBSZWFkYWJsZVN0cmVhbURlZmF1bHRSZWFkZXI8VWludDhBcnJheT4sXG4pOiBSZWFkZXIge1xuICByZXR1cm4gX3JlYWRlckZyb21TdHJlYW1SZWFkZXIoc3RyZWFtUmVhZGVyKTtcbn1cbiJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSwwRUFBMEU7QUFDMUUscUNBQXFDO0FBRXJDLFNBQVMsMEJBQTBCLHVCQUF1QixRQUFRLHFDQUFxQztBQUd2Rzs7Ozs7Ozs7Ozs7Ozs7OztDQWdCQyxHQUNELE9BQU8sU0FBUyx1QkFDZCxZQUFxRDtFQUVyRCxPQUFPLHdCQUF3QjtBQUNqQyJ9