// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
const { isArray } = Array;
function getBeginToken(delimiter) {
  return isArray(delimiter) ? delimiter[0] : delimiter;
}
function getEndToken(delimiter) {
  return isArray(delimiter) ? delimiter[1] : delimiter;
}
function createRegExp(...dv) {
  const beginPattern = "(" + dv.map(getBeginToken).join("|") + ")";
  const pattern = "^(" + "\\ufeff?" + // Maybe byte order mark
  beginPattern + "$([\\s\\S]+?)" + "^(?:" + dv.map(getEndToken).join("|") + ")\\s*" + "$" + (globalThis?.Deno?.build?.os === "windows" ? "\\r?" : "") + "(?:\\n)?)";
  return [
    new RegExp("^" + beginPattern + "$", "im"),
    new RegExp(pattern, "im")
  ];
}
const [RX_RECOGNIZE_YAML, RX_YAML] = createRegExp([
  "---yaml",
  "---"
], "= yaml =", "---");
const [RX_RECOGNIZE_TOML, RX_TOML] = createRegExp([
  "---toml",
  "---"
], "\\+\\+\\+", "= toml =");
const [RX_RECOGNIZE_JSON, RX_JSON] = createRegExp([
  "---json",
  "---"
], "= json =");
export const MAP_FORMAT_TO_RECOGNIZER_RX = {
  yaml: RX_RECOGNIZE_YAML,
  toml: RX_RECOGNIZE_TOML,
  json: RX_RECOGNIZE_JSON
};
export const MAP_FORMAT_TO_EXTRACTOR_RX = {
  yaml: RX_YAML,
  toml: RX_TOML,
  json: RX_JSON
};
//# sourceMappingURL=data:application/json;base64,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