// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
/**
 * Converts a {@linkcode ReadableStream} of {@linkcode Uint8Array}s to a
 * {@linkcode Blob}. Works the same as {@linkcode Response.blob}.
 *
 * @example
 * ```ts
 * import { toBlob } from "https://deno.land/std@$STD_VERSION/streams/to_blob.ts";
 *
 * const stream = ReadableStream.from([new Uint8Array(1), new Uint8Array(2)]);
 * await toBlob(stream); // Blob { size: 3, type: "" }
 * ```
 */ export async function toBlob(stream) {
  return await new Response(stream).blob();
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAwLjIxNy4wL3N0cmVhbXMvdG9fYmxvYi50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgMjAxOC0yMDI0IHRoZSBEZW5vIGF1dGhvcnMuIEFsbCByaWdodHMgcmVzZXJ2ZWQuIE1JVCBsaWNlbnNlLlxuLy8gVGhpcyBtb2R1bGUgaXMgYnJvd3NlciBjb21wYXRpYmxlLlxuXG4vKipcbiAqIENvbnZlcnRzIGEge0BsaW5rY29kZSBSZWFkYWJsZVN0cmVhbX0gb2Yge0BsaW5rY29kZSBVaW50OEFycmF5fXMgdG8gYVxuICoge0BsaW5rY29kZSBCbG9ifS4gV29ya3MgdGhlIHNhbWUgYXMge0BsaW5rY29kZSBSZXNwb25zZS5ibG9ifS5cbiAqXG4gKiBAZXhhbXBsZVxuICogYGBgdHNcbiAqIGltcG9ydCB7IHRvQmxvYiB9IGZyb20gXCJodHRwczovL2Rlbm8ubGFuZC9zdGRAJFNURF9WRVJTSU9OL3N0cmVhbXMvdG9fYmxvYi50c1wiO1xuICpcbiAqIGNvbnN0IHN0cmVhbSA9IFJlYWRhYmxlU3RyZWFtLmZyb20oW25ldyBVaW50OEFycmF5KDEpLCBuZXcgVWludDhBcnJheSgyKV0pO1xuICogYXdhaXQgdG9CbG9iKHN0cmVhbSk7IC8vIEJsb2IgeyBzaXplOiAzLCB0eXBlOiBcIlwiIH1cbiAqIGBgYFxuICovXG5leHBvcnQgYXN5bmMgZnVuY3Rpb24gdG9CbG9iKFxuICBzdHJlYW06IFJlYWRhYmxlU3RyZWFtPFVpbnQ4QXJyYXk+LFxuKTogUHJvbWlzZTxCbG9iPiB7XG4gIHJldHVybiBhd2FpdCBuZXcgUmVzcG9uc2Uoc3RyZWFtKS5ibG9iKCk7XG59XG4iXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsMEVBQTBFO0FBQzFFLHFDQUFxQztBQUVyQzs7Ozs7Ozs7Ozs7Q0FXQyxHQUNELE9BQU8sZUFBZSxPQUNwQixNQUFrQztFQUVsQyxPQUFPLE1BQU0sSUFBSSxTQUFTLFFBQVEsSUFBSTtBQUN4QyJ9