// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
/**
 * Pure functions for common tasks around collection types like arrays and
 * objects.
 *
 * Heavily inspired by
 * {@link https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/ | Kotlin's Collections}
 * package.
 *
 * @module
 */ export * from "./aggregate_groups.ts";
export * from "./associate_by.ts";
export * from "./associate_with.ts";
export * from "./chunk.ts";
export * from "./deep_merge.ts";
export * from "./distinct.ts";
export * from "./distinct_by.ts";
export * from "./drop_while.ts";
export * from "./filter_entries.ts";
export * from "./filter_keys.ts";
export * from "./filter_values.ts";
export * from "./intersect.ts";
export * from "./map_entries.ts";
export * from "./map_keys.ts";
export * from "./map_not_nullish.ts";
export * from "./map_values.ts";
export * from "./partition.ts";
export * from "./partition_entries.ts";
export * from "./permutations.ts";
export * from "./find_single.ts";
export * from "./sliding_windows.ts";
export * from "./sum_of.ts";
export * from "./max_by.ts";
export * from "./max_of.ts";
export * from "./min_by.ts";
export * from "./min_of.ts";
export * from "./sort_by.ts";
export * from "./union.ts";
export * from "./without_all.ts";
export * from "./unzip.ts";
export * from "./zip.ts";
export * from "./join_to_string.ts";
export * from "./max_with.ts";
export * from "./min_with.ts";
export * from "./includes_value.ts";
export * from "./take_last_while.ts";
export * from "./take_while.ts";
export * from "./first_not_nullish_of.ts";
export * from "./drop_last_while.ts";
export * from "./reduce_groups.ts";
export * from "./sample.ts";
export * from "./running_reduce.ts";
//# sourceMappingURL=data:application/json;base64,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