// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
var _computedKey;
import { getLevelByName } from "./levels.ts";
const DEFAULT_FORMATTER = ({ levelName, msg })=>`${levelName} ${msg}`;
_computedKey = Symbol.dispose;
export class BaseHandler {
  level;
  levelName;
  formatter;
  constructor(levelName, options = {}){
    this.level = getLevelByName(levelName);
    this.levelName = levelName;
    this.formatter = options.formatter || DEFAULT_FORMATTER;
  }
  handle(logRecord) {
    if (this.level > logRecord.level) return;
    const msg = this.format(logRecord);
    this.log(msg);
  }
  format(logRecord) {
    return this.formatter(logRecord);
  }
  log(_msg) {}
  setup() {}
  destroy() {}
  [_computedKey]() {
    this.destroy();
  }
}
//# sourceMappingURL=data:application/json;base64,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