// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
import { isWindows } from "./_os.ts";
import { normalizeGlob as posixNormalizeGlob } from "./posix/normalize_glob.ts";
import { normalizeGlob as windowsNormalizeGlob } from "./windows/normalize_glob.ts";
/** Like normalize(), but doesn't collapse "**\/.." when `globstar` is true. */ export function normalizeGlob(glob, options = {}) {
  return isWindows ? windowsNormalizeGlob(glob, options) : posixNormalizeGlob(glob, options);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAwLjIxNy4wL3BhdGgvbm9ybWFsaXplX2dsb2IudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IDIwMTgtMjAyNCB0aGUgRGVubyBhdXRob3JzLiBBbGwgcmlnaHRzIHJlc2VydmVkLiBNSVQgbGljZW5zZS5cbi8vIFRoaXMgbW9kdWxlIGlzIGJyb3dzZXIgY29tcGF0aWJsZS5cblxuaW1wb3J0IHR5cGUgeyBHbG9iT3B0aW9ucyB9IGZyb20gXCIuL19jb21tb24vZ2xvYl90b19yZWdfZXhwLnRzXCI7XG5pbXBvcnQgeyBpc1dpbmRvd3MgfSBmcm9tIFwiLi9fb3MudHNcIjtcbmltcG9ydCB7IG5vcm1hbGl6ZUdsb2IgYXMgcG9zaXhOb3JtYWxpemVHbG9iIH0gZnJvbSBcIi4vcG9zaXgvbm9ybWFsaXplX2dsb2IudHNcIjtcbmltcG9ydCB7XG4gIG5vcm1hbGl6ZUdsb2IgYXMgd2luZG93c05vcm1hbGl6ZUdsb2IsXG59IGZyb20gXCIuL3dpbmRvd3Mvbm9ybWFsaXplX2dsb2IudHNcIjtcblxuZXhwb3J0IHR5cGUgeyBHbG9iT3B0aW9ucyB9O1xuXG4vKiogTGlrZSBub3JtYWxpemUoKSwgYnV0IGRvZXNuJ3QgY29sbGFwc2UgXCIqKlxcLy4uXCIgd2hlbiBgZ2xvYnN0YXJgIGlzIHRydWUuICovXG5leHBvcnQgZnVuY3Rpb24gbm9ybWFsaXplR2xvYihcbiAgZ2xvYjogc3RyaW5nLFxuICBvcHRpb25zOiBHbG9iT3B0aW9ucyA9IHt9LFxuKTogc3RyaW5nIHtcbiAgcmV0dXJuIGlzV2luZG93c1xuICAgID8gd2luZG93c05vcm1hbGl6ZUdsb2IoZ2xvYiwgb3B0aW9ucylcbiAgICA6IHBvc2l4Tm9ybWFsaXplR2xvYihnbG9iLCBvcHRpb25zKTtcbn1cbiJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSwwRUFBMEU7QUFDMUUscUNBQXFDO0FBR3JDLFNBQVMsU0FBUyxRQUFRLFdBQVc7QUFDckMsU0FBUyxpQkFBaUIsa0JBQWtCLFFBQVEsNEJBQTRCO0FBQ2hGLFNBQ0UsaUJBQWlCLG9CQUFvQixRQUNoQyw4QkFBOEI7QUFJckMsNkVBQTZFLEdBQzdFLE9BQU8sU0FBUyxjQUNkLElBQVksRUFDWixVQUF1QixDQUFDLENBQUM7RUFFekIsT0FBTyxZQUNILHFCQUFxQixNQUFNLFdBQzNCLG1CQUFtQixNQUFNO0FBQy9CIn0=